this.name = "Famous Planets Liners Script";
this.author = "Thargoid"; this.copyright = "C 2008 the Oolite team."; 
this.description = "Adds the liners in for Famous Planets routes"; 
this.version = "1.0";

this.startUp = function()
        {
        this.laneOne = [7, 129, 227, 73, 89, 222, 29, 93, 42, 131];
        // Lave, Zaonce, Qutiri, Aronar, Beusrior, Rilace, Atrabiin, Xeeranre, Anarlaqu, Zadies
        this.laneTwo = [7, 129, 227, 73, 50, 35, 186, 188, 111, 250, 141];
        // Lave, Zaonce, Qutiri, Aronar, Aesbion, Isence, Zarece, Tibionis, Reinen, Xexedi, Lerelace
        this.laneThree = [131, 62, 150, 198, 36, 28, 16, 221, 99];
        // Zadies, Esusti, Xeer, Xezaor, Reesdice, Arexe, Rizala, Zasoceat, Teraed
        this.laneFour = [99, 241, 86, 126, 18, 246];
        // Teraed, Qurave, Velete, Anerbe, Teanrebi, Tianve
        }

this.shipExitedWitchspace = this.shipLaunchedFromStation = function()
	{
	if(!galaxyNumber == 0) // if we're not in Galaxy 1, stop here
		{ return; }
	
	if(system.countShipsWithRole("FP_strelka") > 0) // if there's already special Strelka's in the system, no need to add any more
		{ return; }

	if(this.laneOne.indexOf(system.ID) != -1) // if we're in a system on lane one
		{
		this.laneOneCount = Math.ceil((Math.random() * 2) + 0.5); // random number between 1 and 3
		let spawnCounter = 0 ; // reset the counter
		for(spawnCounter = 0;spawnCounter<this.laneOneCount;spawnCounter++)
			{
			let zloc = 0.1 + (Math.random() * 0.8); // add liner between 10% and 90% of the way between witchpoint and planet within a 10km axial radius.
			system.legacy_addShipsWithinRadius("FP_laneOneStrelka", 1, "wpu", [0, 0, zloc], 10000);
			}
		if(Math.random() < 0.2) // 20% chance of a parked Strelka within 10km of the main station
			{
			system.legacy_addShipsWithinRadius("FP_parkedLaneOneStrelka", 1, "abs", system.mainStation.position, 5000);
			}

		if(this.launchCheckTimerOne)
			{
			this.launchCheckTimerOne.start();
			}
		else
			{
			this.launchCheckTimerOne = new Timer(this, this.stationLaunchOne, 0, 600);
			}
		}

	if(this.laneTwo.indexOf(system.ID) != -1) // if we're in a system on lane two
		{
		this.laneTwoCount = Math.ceil((Math.random() * 2) + 0.5); // random number between 1 and 3
		let spawnCounter = 0 ; // reset the counter
		for(spawnCounter = 0;spawnCounter<this.laneTwoCount;spawnCounter++)
			{
			let zloc = 0.1 + (Math.random() * 0.8); // add liner between 10% and 90% of the way between witchpoint and planet within a 10km axial radius.
			system.legacy_addShipsWithinRadius("FP_laneTwoStrelka", 1, "wpu", [0, 0, zloc], 10000);
			}
		if(Math.random() < 0.2) // 20% chance of a parked Strelka within 10km of the main station
			{
			system.legacy_addShipsWithinRadius("FP_parkedLaneTwoStrelka", 1, "abs", system.mainStation.position, 5000);
			}

		if(this.launchCheckTimerTwo)
			{
			this.launchCheckTimerTwo.start();
			}
		else
			{
			this.launchCheckTimerTwo = new Timer(this, this.stationLaunchTwo, 0, 600);
			}
		}

	if(this.laneThree.indexOf(system.ID) != -1) // if we're in a system on lane three
		{
		this.laneThreeCount = Math.ceil((Math.random() * 2) + 0.5); // random number between 1 and 3
		let spawnCounter = 0 ; // reset the counter
		for(spawnCounter = 0;spawnCounter<this.laneThreeCount;spawnCounter++)
			{
			let zloc = 0.1 + (Math.random() * 0.8); // add liner between 10% and 90% of the way between witchpoint and planet within a 10km axial radius.
			system.legacy_addShipsWithinRadius("FP_laneThreeStrelka", 1, "wpu", [0, 0, zloc], 10000);
			}
		if(Math.random() < 0.2) // 20% chance of a parked Strelka within 10km of the main station
			{
			system.legacy_addShipsWithinRadius("FP_parkedLaneThreeStrelka", 1, "abs", system.mainStation.position, 5000);
			}

		if(this.launchCheckTimerThree)
			{
			this.launchCheckTimerThree.start();
			}
		else
			{
			this.launchCheckTimerThree = new Timer(this, this.stationLaunchThree, 0, 600);
			}
		}

	if(this.laneFour.indexOf(system.ID) != -1) // if we're in a system on lane four
		{
		this.laneFourCount = Math.ceil((Math.random() * 2) + 0.5); // random number between 1 and 3
		let spawnCounter = 0 ; // reset the counter
		for(spawnCounter = 0;spawnCounter<this.laneFourCount;spawnCounter++)
			{
			let zloc = 0.1 + (Math.random() * 0.8); // add liner between 10% and 90% of the way between witchpoint and planet within a 10km axial radius.
			system.legacy_addShipsWithinRadius("FP_laneFourStrelka", 1, "wpu", [0, 0, zloc], 10000);
			}
		if(Math.random() < 0.2) // 20% chance of a parked Strelka within 10km of the main station
			{
			system.legacy_addShipsWithinRadius("FP_parkedLaneFourStrelka", 1, "abs", system.mainStation.position, 5000);
			}
		}

		if(this.launchCheckTimerFour)
			{
			this.launchCheckTimerFour.start();
			}
		else
			{
			this.launchCheckTimerFour = new Timer(this, this.stationLaunchFour, 0, 600);
			}
        }

this.shipWillEnterWitchspace = this.shipWillDockWithStation = this.shipDied = function()
	{
	if(this.launchCheckTimerOne)
		{
		this.launchCheckTimerOne.stop();
		}
	if(this.launchCheckTimerTwo)
		{
		this.launchCheckTimerTwo.stop();
		}
	if(this.launchCheckTimerThree)
		{
		this.launchCheckTimerThree.stop();
		}
	if(this.launchCheckTimerFour)
		{
		this.launchCheckTimerFour.stop();
		}
	} 

this.stationLaunchOne = function()
	{
	if(Math.random() < 0.1) // 10% chance of a launch of a strelka route 1
		{
		system.mainStation.AIState = "IDLE"; 
		system.mainStation.setAI("FP_launchStrelkaOneAI.plist");
		}

	if(Math.random() < 0.5) // 50% chance of stopping the timer
		{
		this.launchCheckTimerOne.stop();
		}
	}

this.stationLaunchTwo = function()
	{
	if(Math.random() < 0.1) // 10% chance of a launch of a strelka route 2
		{
		system.mainStation.AIState = "IDLE"; 
		system.mainStation.setAI("FP_launchStrelkaTwoAI.plist");
		}

	if(Math.random() < 0.5) // 50% chance of stopping the timer
		{
		this.launchCheckTimerTwo.stop();
		}
	}

this.stationLaunchThree = function()
	{
	if(Math.random() < 0.1) // 10% chance of a launch of a strelka route 3
		{
		system.mainStation.AIState = "IDLE"; 
		system.mainStation.setAI("FP_launchStrelkaThreeAI.plist");
		}

	if(Math.random() < 0.5) // 50% chance of stopping the timer
		{
		this.launchCheckTimerThree.stop();
		}
	}

this.stationLaunchFour = function()
	{
	if(Math.random() < 0.1) // 10% chance of a launch of a strelka route 4
		{
		system.mainStation.AIState = "IDLE"; 
		system.mainStation.setAI("FP_launchStrelkaFourAI.plist");
		}

	if(Math.random() < 0.5) // 50% chance of stopping the timer
		{
		this.launchCheckTimerFour.stop();
		}
	}